/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.user;

import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.UserUtils;
import com.ibm.hsc.websm.user.SetPassword;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import com.ibm.websm.etc.EWorkingListener;
import com.ibm.websm.etc.StringVector;
import com.ibm.websm.mobject.DefSysEventSupport;
import com.ibm.websm.mobject.MOClass;
import com.ibm.websm.mobject.MOClassImpl;
import com.ibm.websm.mobject.MOState;
import com.ibm.websm.mobject.MOXContainerObj;
import com.ibm.websm.mobject.MOXReference;
import com.ibm.websm.mobject.MObject;
import com.ibm.websm.mobject.MObjectImpl;
import java.io.File;
import java.text.StringCharacterIterator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class UserMObject
extends MObjectImpl {
    private String _name = "";
    private MOState _mostate = null;
    private String _fullname = "";
    private String _loginname = "";
    private String _roles = "";
    private String _uid = "";
    private int _passwordExpirationDays;
    private static int _defaultPasswordExpirationDays;
    private static int _minimumPWLength;

    public UserMObject(String string) throws Throwable {
        try {
            this.setKey(string);
            this._mostate = UserMObject._createUserMOState(null, this.getName());
        }
        catch (Throwable throwable) {
            throwable.getMessage();
        }
    }

    public UserMObject(String string, Hashtable hashtable) throws Throwable {
        try {
            this.setKey(string);
            this._name = (String)hashtable.get("name");
            this._mostate = (MOState)hashtable.get("MOState");
            this._fullname = (String)hashtable.get("fullName_PROP");
            this._loginname = (String)hashtable.get("loginName_PROP");
            this._roles = (String)hashtable.get("roles_PROP");
            Integer n = (Integer)hashtable.get("passwordExpirationDays_PROP");
            if (n != null) {
                this._passwordExpirationDays = n;
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public MOState getMOState() {
        return this._mostate;
    }

    public static MObjectImpl getInstance(MOXReference mOXReference) throws Throwable {
        String string = mOXReference.getKey();
        UserMObject userMObject = new UserMObject(string);
        return userMObject;
    }

    public static Boolean isRMCFileExists(String string) throws Throwable {
        if (string != null && string.trim().length() > 0) {
            File file = new File(string);
            if (!file.exists()) {
                return new Boolean("false");
            }
            return new Boolean("true");
        }
        return new Boolean("false");
    }

    public static void callFireMOEvent(MOXContainerObj mOXContainerObj) {
        block3: {
            if (mOXContainerObj == null) break block3;
            try {
                String string = mOXContainerObj.getKey();
                MObject mObject = mOXContainerObj.getMObject();
                Hashtable hashtable = mObject.getPropertyValues(null, null, null);
                String string2 = (String)hashtable.get("loginName_PROP");
                MOState mOState = UserMObject._createUserMOState(null, string2);
                hashtable.put("MOState", mOState);
                MOClassImpl mOClassImpl = MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.user.UserMObject");
                DefSysEventSupport defSysEventSupport = (DefSysEventSupport)mOClassImpl.getEventSupport();
                if (defSysEventSupport != null) {
                    defSysEventSupport.fireMOEvent(string, "OAE", (Object)mOState, hashtable);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static MOXContainerObj createNewInstance(Hashtable hashtable, EWorkingListener eWorkingListener) throws Throwable {
        eWorkingListener = null;
        if (eWorkingListener != null) {
            eWorkingListener.showDialog(true);
        }
        String string = (String)hashtable.get("loginName_PROP");
        String string2 = (String)hashtable.get("fullName_PROP");
        if (string2.trim().length() > 0) {
            string2 = "'" + string2.trim() + "'";
        }
        String string3 = (String)hashtable.get("roles_PROP");
        String string4 = (String)hashtable.get("sfpRmcUser_PROP");
        String string5 = "";
        string5 = string3.indexOf(",") > 0 ? string3.substring(0, string3.indexOf(",")) : string3;
        String string6 = "";
        if (eWorkingListener != null) {
            eWorkingListener.setProperties(8);
        }
        string6 = "/opt/hsc/bin/HSCUserConf -c " + string;
        if (string2 != null) {
            string6 = string6 + " " + string2;
        }
        string6 = string6 + " " + string5;
        if (string3 != null) {
            string6 = string6 + " " + string3;
        }
        string6 = !string3.equals("HSC_Admin") ? string6 + " -rmcadd" : string6 + " -rmcnothing";
        if (IDebug.enabled) {
            IDebug.println((String)("useradd cmd from UserMObject :" + string6));
        }
        EExecResult eExecResult = EExec.Exec((String)string6, (EWorkingListener)eWorkingListener);
        if (IDebug.enabled) {
            IDebug.println((String)("HSCUserConf in createInstance - rc=" + eExecResult.rc + ",stdout=" + eExecResult.stdout + ",stderr=" + eExecResult.stderr));
        }
        if (eExecResult.rc == 0) {
            String string7;
            Object object;
            String string8 = "";
            EExecResult eExecResult2 = EExec.Exec((String)("grep " + string + " /etc/passwd | cut -f 1,3 -d:"), (EWorkingListener)eWorkingListener);
            if (eExecResult2.stdout != null) {
                object = new StringTokenizer(eExecResult2.stdout, "\n");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string8 = ((StringTokenizer)object).nextToken();
                    if (IDebug.enabled) {
                        IDebug.println((String)("_loginId : " + string8));
                    }
                    if (string8.indexOf(":") <= 0 || !string8.substring(0, string8.indexOf(":")).equals(string)) continue;
                    string8 = string8.substring(string8.indexOf(":") + 1, string8.length());
                    if (!IDebug.enabled) break;
                    IDebug.println((String)("_loginId after extract: " + string8));
                    break;
                }
            }
            if ((object = (Integer)hashtable.get("passwordExpirationDays_PROP")) != null) {
                string6 = "/opt/hsc/bin/HSCUserConf -x -M " + ((Integer)object).toString() + " " + string;
                string7 = EExec.Exec((String)string6);
                hashtable.put("passwordExpirationDays_PROP", object);
            } else {
                hashtable.put("passwordExpirationDays_PROP", new Integer(_defaultPasswordExpirationDays));
            }
            string7 = "";
            hashtable.put("name", string);
            hashtable.put("loginName_PROP", string);
            UserMObject userMObject = new UserMObject(string8, hashtable);
            MOClassImpl mOClassImpl = MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.user.UserMObject");
            if (eWorkingListener != null) {
                eWorkingListener.setProperties(16);
                eWorkingListener.eof(0);
                eWorkingListener.showDialog(false);
            }
            MOClass mOClass = MObjectImpl.getMOClassProxy((String)"com.ibm.hsc.websm.user.UserMObject");
            MOXReference mOXReference = new MOXReference(mOClass, string8, hashtable);
            MOState mOState = UserMObject._createUserMOState(null, string8);
            return new MOXContainerObj(mOXReference, string8, mOState);
        }
        if (eWorkingListener != null) {
            eWorkingListener.setProperties(16);
            eWorkingListener.eof(0);
            eWorkingListener.showDialog(false);
        }
        return null;
    }

    public static String getActionExposeSuffix() {
        return new String("_ACTION");
    }

    private static StringBuffer parsePassword(String string) {
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer("");
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string2);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c == '\\') {
                stringBuffer.append(c);
                stringBuffer.append(c);
                stringBuffer.append(c);
            } else if (c == '`' || c == '$' || c == '\"' || c == '\'' || c == ';' || c == '|' || c == '<' || c == '>' || c == '(' || c == ')' || c == '&') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            c = stringCharacterIterator.next();
        }
        return stringBuffer;
    }

    public static Integer changeUserPassword(String string, String string2, EWorkingListener eWorkingListener, MOXContainerObj mOXContainerObj) throws Throwable {
        try {
            eWorkingListener = null;
            if (string2 != null && string != null) {
                Process process;
                if (eWorkingListener != null) {
                    eWorkingListener.showDialog(true);
                    eWorkingListener.appendStdout(HSCResourceBundleUtil.getMessage("UserBundle", "CHANGE_PASSWORD_MESSAGE", "Changing user password,\nPlease standby."));
                    eWorkingListener.setProperties(8);
                }
                StringBuffer stringBuffer = UserMObject.parsePassword(string2);
                SetPassword setPassword = new SetPassword(string, string2);
                String string3 = setPassword.encryptPW(stringBuffer.toString());
                String string4 = "/opt/hsc/bin/HSCUserConf -e " + string + " " + string3;
                int n = 0;
                try {
                    process = Runtime.getRuntime().exec(string4);
                    n = process.waitFor();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (n == 0) {
                    UserMObject.callFireMOEvent(mOXContainerObj);
                    if ("hscroot".equals(string.trim())) {
                        string4 = "/opt/hsc/bin/HSCUserConf -s " + string + " " + stringBuffer;
                        try {
                            process = Runtime.getRuntime().exec(string4);
                            n = process.waitFor();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                if (eWorkingListener != null) {
                    eWorkingListener.setProperties(16);
                    eWorkingListener.eof(n);
                    eWorkingListener.showDialog(false);
                }
                return new Integer(n);
            }
            return new Integer(22222);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return new Integer(2);
        }
    }

    public static Boolean confirmPassword(String string, String string2) {
        if (string == null || string2 == null || string.trim().length() == 0 || string2.trim().length() == 0) {
            return new Boolean("false");
        }
        if (UserMObject.isAlreadyExist(string).toString().trim().equals("false")) {
            return new Boolean("false");
        }
        StringBuffer stringBuffer = UserMObject.parsePassword(string2);
        String string3 = "/opt/hsc/bin/HSCUserConf -o " + string + " " + stringBuffer;
        int n = 0;
        try {
            Process process = Runtime.getRuntime().exec(string3);
            n = process.waitFor();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            return new Boolean("true");
        }
        return new Boolean("false");
    }

    public static Boolean checkPassword(String string, String string2) {
        if (string.equals(string2)) {
            return new Boolean(true);
        }
        return new Boolean(false);
    }

    public static String getPropertyExposeSuffix() {
        return new String("_PROP");
    }

    public String getLoginName_PROP() {
        return this._loginname;
    }

    public String getFullName_PROP() {
        return this._fullname;
    }

    public String getRoles_PROP() {
        return this._roles;
    }

    public String getUid_PROP() {
        return this._uid;
    }

    public void setLoginName_PROP(String string) {
        this._loginname = string;
    }

    public void setFullName_PROP(String string) {
        this._fullname = string;
    }

    public void setRoles_PROP(String string) {
        this._roles = string;
    }

    public void setPasswordExpirationDays_PROP(int n) {
        this._passwordExpirationDays = n;
    }

    public int getPasswordExpirationDays_PROP() {
        return this._passwordExpirationDays;
    }

    public int getMinimumPasswordLength_PROP() {
        return _minimumPWLength;
    }

    public int getdefaultPasswordExpiration_PROP() {
        return _defaultPasswordExpirationDays;
    }

    public void setUid_PROP(String string) {
        this._uid = string;
    }

    public static Vector getContainerObjList(String[] stringArray, Object object) throws Throwable {
        _minimumPWLength = UserUtils.getMinPwdLength();
        _defaultPasswordExpirationDays = UserUtils.getMaxPwdExpirationDays();
        MOClass mOClass = MObjectImpl.getMOClassProxy((String)"com.ibm.hsc.websm.user.UserMObject");
        Vector<MOXContainerObj> vector = new Vector<MOXContainerObj>();
        StringVector stringVector = UserMObject._getUserList();
        Enumeration enumeration = stringVector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = string.substring(0, string.indexOf(":"));
            String string3 = string.substring(string.indexOf(":") + 1, string.length());
            String string4 = string3.substring(string3.indexOf(":"), string3.indexOf(":") + 1);
            string3 = string3.substring(string3.indexOf(":") + 1, string3.length());
            String string5 = string3.substring(0, string3.indexOf(":"));
            String string6 = string3.substring(string3.indexOf(":") + 1, string3.length());
            int n = UserUtils.getPwdExpirationDays(string2);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("name", string5);
            hashtable.put("fullName_PROP", string6);
            hashtable.put("passwordExpirationDays_PROP", new Integer(n));
            hashtable.put("minimumPasswordLength_PROP", new Integer(_minimumPWLength));
            hashtable.put("defaultPasswordExpiration_PROP", new Integer(_defaultPasswordExpirationDays));
            MOXReference mOXReference = new MOXReference(mOClass, string5, hashtable);
            MOState mOState = UserMObject._createUserMOState(null, string5);
            vector.addElement(new MOXContainerObj(mOXReference, string2, mOState));
        }
        return vector;
    }

    public static String getClassName() {
        return "UserMObject ";
    }

    public static String[] getRoles() {
        EExecResult eExecResult = EExec.Exec((String)"/opt/hsc/bin/getUserList -Role");
        if (eExecResult.rc != 0) {
            return null;
        }
        if (eExecResult.stdout != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(eExecResult.stdout, "\n");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
            return stringArray;
        }
        return null;
    }

    public static String[] getRolesDescription() throws Throwable {
        EExecResult eExecResult = EExec.Exec((String)"cat /opt/hsc/data/RoleRegistration.db | cut -f 2 -d:");
        if (eExecResult.rc != 0) {
            return null;
        }
        if (eExecResult.stdout != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(eExecResult.stdout, "\n");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
            return stringArray;
        }
        return null;
    }

    public Hashtable getPropertyValues(String[] stringArray, String string, Object object) throws Throwable {
        if (stringArray != null) {
            return super.getPropertyValues(stringArray, string, object);
        }
        if (IDebug.enabled) {
            IDebug.println((String)("getKey() in getPropertyValues() : " + this.getKey()));
        }
        EExecResult eExecResult = EExec.Exec((String)("grep :x:" + this.getKey() + ": /etc/passwd"));
        if (IDebug.enabled) {
            IDebug.println((String)("In getPropertyValues() -  rc=" + eExecResult.rc + ",stdout=" + eExecResult.stdout + ",stderr=" + eExecResult.stderr));
        }
        if (eExecResult.stdout != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(eExecResult.stdout, ":");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            if (string4.equals(this.getKey())) {
                Object object2;
                this._uid = string4;
                string3 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                eExecResult = EExec.Exec((String)"cat /opt/hsc/data/RoleRegistration.db | cut -f 1 -d:");
                if (eExecResult.rc != 0) {
                    return null;
                }
                String string6 = string2 + ",";
                if (eExecResult.stdout != null) {
                    object2 = new StringTokenizer(eExecResult.stdout, "\n");
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        string6 = string6 + ((StringTokenizer)object2).nextToken() + ",";
                    }
                    string6 = string6.substring(0, string6.length() - 1);
                }
                object2 = new Hashtable<String, String>();
                ((Hashtable)object2).put("name", string2);
                this._name = string2;
                ((Hashtable)object2).put("loginName_PROP", string2);
                if (string5.equals(" ")) {
                    string5 = "";
                }
                ((Hashtable)object2).put("fullName_PROP", string5);
                this._fullname = string5;
                ((Hashtable)object2).put("roles_PROP", string6);
                ((Hashtable)object2).put("Uid_PROP", string4);
                int n = UserUtils.getPwdExpirationDays(this._name);
                ((Hashtable)object2).put("passwordExpirationDays_PROP", new Integer(n));
                return object2;
            }
            return null;
        }
        return null;
    }

    public static Hashtable getUserProperties(String string) throws Throwable {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (string != null) {
            string2 = string.substring(0, string.indexOf(":"));
            string5 = string.substring(string.indexOf(":") + 1, string.length());
            string4 = string5.substring(0, string5.indexOf(":"));
            string3 = string5.substring(string5.indexOf(":") + 1, string5.length());
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("_loginName", string2);
            hashtable.put("_fullName", string3);
            hashtable.put("_id", string4);
            return hashtable;
        }
        return null;
    }

    public static String[] getUserGroup(String string) throws Throwable {
        StringTokenizer stringTokenizer;
        EExecResult eExecResult = EExec.Exec((String)("/opt/hsc/bin/getUserList -userdelete " + string));
        if (eExecResult.stdout != null && (stringTokenizer = new StringTokenizer(eExecResult.stdout, "\n")).countTokens() > 0) {
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
            return stringArray;
        }
        return null;
    }

    public static Hashtable getHscGroups(String string) throws Throwable {
        if (string == null) {
            return null;
        }
        EExecResult eExecResult = EExec.Exec((String)("/opt/hsc/bin/getUserList -userroles " + string));
        if (eExecResult.stdout != null) {
            Object object;
            String string2 = eExecResult.stdout;
            String string3 = string2.substring(0, string2.indexOf("~"));
            String string4 = string2.substring(string2.indexOf("~") + 1, string2.length());
            String string5 = string4.substring(0, string4.indexOf("~"));
            String string6 = string4.substring(string4.indexOf("~") + 1, string4.length());
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "\n");
            if (stringTokenizer.countTokens() > 0) {
                object = new String[stringTokenizer.countTokens()];
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    object[n] = stringTokenizer.nextToken();
                    ++n;
                }
                hashtable.put("roleList", object);
            }
            if (((StringTokenizer)(object = new StringTokenizer(string5, "\n"))).countTokens() > 0) {
                String[] stringArray = new String[((StringTokenizer)object).countTokens()];
                int n = 0;
                while (((StringTokenizer)object).hasMoreTokens()) {
                    stringArray[n] = ((StringTokenizer)object).nextToken();
                    ++n;
                }
                hashtable.put("roleDesc", stringArray);
            }
            hashtable.put("userProp", UserMObject.getUserProperties(string6));
            return hashtable;
        }
        return null;
    }

    public static Boolean isAlreadyExist(String string) {
        if (IDebug.enabled) {
            IDebug.println((String)"in Mobject check..");
        }
        EExecResult eExecResult = EExec.Exec((String)("grep -c -w " + string + " /etc/passwd | cut -f 1 -d:"));
        if (IDebug.enabled) {
            IDebug.println((String)("grep count of " + string + " is " + eExecResult.stdout));
        }
        if (eExecResult.stdout != null) {
            String string2 = eExecResult.stdout;
            if (!string2.trim().equals("0")) {
                EExecResult eExecResult2 = EExec.Exec((String)("grep  " + string + " /etc/passwd | cut -f 1 -d:"));
                if (eExecResult2.stdout != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(eExecResult2.stdout, "\n");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken();
                        if (!string3.trim().equals(string)) continue;
                        return new Boolean("true");
                    }
                    return new Boolean("false");
                }
                return new Boolean("false");
            }
            return new Boolean("false");
        }
        return new Boolean("false");
    }

    public static Integer getDefaultPWexpDays() {
        return new Integer(_defaultPasswordExpirationDays);
    }

    public static void setChanges(Hashtable hashtable, EWorkingListener eWorkingListener) throws Throwable {
        eWorkingListener = null;
        MOClassImpl mOClassImpl = MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.user.UserMObject");
        String string = (String)hashtable.get("uid");
        MOClass mOClass = MObjectImpl.getMOClassProxy((String)"com.ibm.hsc.websm.user.UserMObject");
        MObjectImpl mObjectImpl = mOClassImpl.getMObjectImpl(new MOXReference(mOClass, string, hashtable));
        mObjectImpl.setPropertyValues(hashtable, string, eWorkingListener);
    }

    public void setPropertyValues(Hashtable hashtable, String string, EWorkingListener eWorkingListener) throws Throwable {
        EExecResult eExecResult;
        String string2;
        if (eWorkingListener != null) {
            eWorkingListener.showDialog(true);
        }
        if ((string2 = (String)hashtable.get("fullName_PROP")) != null && string2.equals(" ")) {
            string2 = null;
        }
        String string3 = (String)hashtable.get("loginName_PROP");
        String string4 = (String)hashtable.get("roles_PROP");
        String string5 = (String)hashtable.get("oldValue");
        String string6 = (String)hashtable.get("sfpRmcUser_PROP");
        Integer n = (Integer)hashtable.get("passwordExpirationDays_PROP");
        String string7 = "";
        if (n != null && string3 != null) {
            string7 = "/opt/hsc/bin/HSCUserConf -x -M " + n.toString() + " " + string3;
            eExecResult = EExec.Exec((String)string7);
        }
        string7 = "/opt/hsc/bin/HSCUserConf -m ";
        if (string3 != null & string2 == null & string4 == null) {
            string7 = string7 + " -l " + string3 + " " + string5;
        }
        if (string3 == null & string2 != null & string4 == null) {
            string7 = string7 + " -c '" + string2 + "' " + string5;
        }
        if (string3 == null & string2 == null & string4 != null) {
            string7 = string7 + " -G " + string4 + " " + string5;
        }
        if (string3 == null & string2 != null & string4 != null) {
            string7 = string7 + " -c '" + string2 + "' -G " + string4 + " " + string5;
        }
        if (string3 != null & string2 != null & string4 == null) {
            string7 = string7 + " -l " + string3 + " -c '" + string2 + "' " + string5;
        }
        if (string3 != null & string2 != null & string4 != null) {
            string7 = string7 + " -l " + string3 + " -c '" + string2 + "' -G " + string4 + " " + string5;
        }
        if (string3 != null & string2 == null & string4 != null) {
            string7 = string7 + " -l " + string3 + " -G " + string4 + " " + string5;
        }
        if (eWorkingListener != null) {
            eWorkingListener.setProperties(8);
        }
        string7 = !string4.equals("HSC_Admin") ? string7 + " -rmcadd" : string7 + " -rmcnothing";
        eExecResult = EExec.Exec((String)string7);
        if (eExecResult.rc == 0) {
            MOClassImpl mOClassImpl = MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.user.UserMObject");
            DefSysEventSupport defSysEventSupport = (DefSysEventSupport)mOClassImpl.getEventSupport();
            DefSysEventSupport defSysEventSupport2 = (DefSysEventSupport)this.getEventSupport();
            if (string2 != null) {
                this.setFullName_PROP(string2);
                this._notifyPropChangeListeners(defSysEventSupport, defSysEventSupport2, "fullName_PROP", string2);
            }
            if (string3 != null) {
                this._name = string3;
                this._notifyPropChangeListeners(defSysEventSupport, defSysEventSupport2, "name", string3);
                this.setLoginName_PROP(string3);
                this._notifyPropChangeListeners(defSysEventSupport, defSysEventSupport2, "loginName_PROP", string3);
            }
            if (string2 != null) {
                hashtable.put("fullName_PROP", string2);
            }
            if (string3 != null) {
                hashtable.put("loginName_PROP", string3);
                hashtable.put("name", string3);
            }
            if (string4 != null) {
                hashtable.put("roles_PROP", string4);
            }
            if (n != null) {
                string7 = string3 != null ? "/opt/hsc/bin/HSCUserConf -x -M " + n.toString() + " " + string3 : "/opt/hsc/bin/HSCUserConf -x -M " + n.toString() + " " + this._name;
                EExecResult eExecResult2 = EExec.Exec((String)string7);
                hashtable.put("passwordExpirationDays_PROP", n);
                this._notifyPropChangeListeners(defSysEventSupport, defSysEventSupport2, "passwordExpirationDays_PROP", n);
            }
            if (IDebug.enabled) {
                IDebug.println((String)("in setProp - key : " + this.getKey()));
            }
        }
        if (eWorkingListener != null) {
            eWorkingListener.setProperties(16);
            eWorkingListener.eof(0);
            eWorkingListener.showDialog(false);
        }
    }

    private static UserAttributes _getUserAttributes(String string) {
        EExecResult eExecResult = EExec.Exec((String)("grep :x:" + string + ": /etc/passwd"));
        StringTokenizer stringTokenizer = new StringTokenizer(eExecResult.stdout, ":");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        Integer n = new Integer(stringTokenizer.nextToken());
        Integer n2 = new Integer(stringTokenizer.nextToken());
        String string4 = stringTokenizer.nextToken();
        return new UserAttributes(string2, string4);
    }

    private static MOState _createUserMOState(String string, String string2) {
        String string3 = null;
        return new MOState("users_user", string, string3, true);
    }

    private static StringVector _getUserList() {
        StringVector stringVector = new StringVector();
        EExecResult eExecResult = EExec.Exec((String)"/opt/hsc/bin/getUserList -list");
        if (eExecResult.rc != 0) {
            return null;
        }
        if (eExecResult.stdout != null) {
            String string = eExecResult.stdout;
            if (string.trim().length() > 0) {
                string = string.substring(0, string.length() - 1);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                stringVector.addElement((String)stringTokenizer.nextElement());
            }
        }
        return stringVector;
    }

    private static Hashtable _getPropertyValues(String string, String[] stringArray) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(stringArray.length + 1);
        EExecResult eExecResult = EExec.Exec((String)("grep :x:" + string + ": /etc/passwd | cut -f 1,3,5 -d:"));
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (eExecResult.stdout != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(eExecResult.stdout, ":");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                string4 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
                if (string3.trim().length() > 0) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                if (string3.trim().equals("")) {
                    string3 = "";
                }
                if (string4.equals(string)) break;
            }
        }
        int n = 0;
        while (n < stringArray.length) {
            String string5 = stringArray[n];
            if (string5.equals("name")) {
                hashtable.put(string5, string4);
            } else if (string5.equals("fullName_PROP")) {
                hashtable.put(string5, string3);
            }
            ++n;
        }
        return hashtable;
    }

    private void _notifyPropChangeListeners(DefSysEventSupport defSysEventSupport, DefSysEventSupport defSysEventSupport2, String string, Object object) throws Throwable {
        if (defSysEventSupport != null) {
            defSysEventSupport.fireMOPropertyChange(this.getKey(), string, null, object);
        }
        if (defSysEventSupport2 != null) {
            defSysEventSupport2.fireMOPropertyChange(string, null, object);
        }
    }

    private static void _notifyMOEventListeners(DefSysEventSupport defSysEventSupport, DefSysEventSupport defSysEventSupport2, String string, String string2, Object object) throws Throwable {
        if (defSysEventSupport != null) {
            defSysEventSupport.fireMOEvent(string, string2, object);
        }
        if (defSysEventSupport2 != null) {
            defSysEventSupport2.fireMOEvent(string2, object);
        }
    }

    public static void deleteUser(Object[] objectArray, EWorkingListener eWorkingListener) throws Throwable {
        block14: {
            try {
                eWorkingListener = null;
                MOClassImpl mOClassImpl = MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.user.UserMObject");
                DefSysEventSupport defSysEventSupport = (DefSysEventSupport)mOClassImpl.getEventSupport();
                if (eWorkingListener != null) {
                    eWorkingListener.showDialog(true);
                }
                int n = 0;
                int n2 = 0;
                while (n2 < objectArray.length) {
                    EExecResult eExecResult;
                    Object object;
                    MObjectImpl mObjectImpl = mOClassImpl.getMObjectImpl((MOXReference)objectArray[n2]);
                    String string = "";
                    if (eWorkingListener != null) {
                        eWorkingListener.setProperties(8);
                    }
                    EExecResult eExecResult2 = EExec.Exec((String)("grep :x:" + mObjectImpl.getKey() + ": /etc/passwd | cut -f 1,3 -d:"));
                    String string2 = "";
                    String string3 = "";
                    if (eExecResult2.stdout != null) {
                        object = new StringTokenizer(eExecResult2.stdout, ":");
                        while (((StringTokenizer)object).hasMoreTokens()) {
                            string2 = ((StringTokenizer)object).nextToken();
                            string3 = ((StringTokenizer)object).nextToken();
                            if (string3.equals(mObjectImpl.getKey())) break;
                        }
                    }
                    object = "";
                    if (string2.trim().length() > 0) {
                        StringTokenizer stringTokenizer;
                        eExecResult = EExec.Exec((String)("grep -F -w " + string2 + " /etc/group |cut -f 1 -d:"));
                        if (eExecResult.stdout != null && (stringTokenizer = new StringTokenizer(eExecResult.stdout, "\n")).countTokens() > 0) {
                            int n3 = 0;
                            while (stringTokenizer.hasMoreTokens()) {
                                object = stringTokenizer.nextToken().equals("HSC_Admin") ? " -rmcnothing" : " -rmcdelete";
                                ++n3;
                            }
                        }
                    }
                    string = "/opt/hsc/bin/HSCUserConf -d " + string2 + " " + (String)object;
                    if (IDebug.enabled) {
                        IDebug.println((String)("userdel cmd in UserMObject is : " + string));
                    }
                    eExecResult = EExec.Exec((String)string, (EWorkingListener)eWorkingListener);
                    if (IDebug.enabled) {
                        IDebug.println((String)("HSCUserConf cmd result:" + eExecResult.rc));
                    }
                    if (eExecResult.rc == 0 || eExecResult.rc == 3072) {
                        defSysEventSupport.fireMOEvent(mObjectImpl.getKey(), "ODE", (Object)new MOState(null, "deleted"));
                        mOClassImpl.removeMObject(mObjectImpl.getKey());
                    }
                    n += eExecResult.rc;
                    ++n2;
                }
                if (eWorkingListener != null) {
                    eWorkingListener.setProperties(16);
                    eWorkingListener.eof(0);
                    eWorkingListener.showDialog(false);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (eWorkingListener == null) break block14;
                eWorkingListener.setProperties(16);
                eWorkingListener.eof(1);
                eWorkingListener.showDialog(false);
            }
        }
    }

    public static class UserAttributes {
        String _name;
        String _fullName;

        public String getLoginName() {
            return this._name;
        }

        public String getFullName() {
            return this._fullName;
        }

        public UserAttributes(String string, String string2) {
        }
    }
}

